MYAPP.loadScheme({

    "list":[
        {
            "name":"Dashboard",
            "step":{
                "list":[
                    {
                        "action":{
                            "list":[
                                {
                                    "pageUrl":"dashboard.htm",
                                    "parameters":{
                                        "unit":{ }
                                    }
                                }
                            ]
                        }
                    }
                ]
            }
        },
        {
            "name":"System",
            "list":[
                {
                    "name":"General",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_general.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"Switch",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_switch.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                {
                    "name":"Capability",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_capability.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"File",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Set Start-Up",
                                    "list":[
                                        {
                                            "name":"Set Start-Up",
                                            "pageUrl":"system_file_set_start_up.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"system_file_show.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Copy",
                                            "pageUrl":"system_file_copy.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        
                                            {
                                                "name":"Automatic Operation Code Upgrade",
                                                "pageUrl":"system_file_automatic_operation_code_upgrade.htm"
                                            }
                                        
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"Time",
                    "step":{
                        "list":[
                            {
                                "name":"Configure General",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_time_configure_general.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Time Server",
                                "action":{
                                    "defaultValue":"Configure SNTP Server",
                                    "list":[
                                        {
                                            "name":"Configure SNTP Server",
                                            "pageUrl":"system_time_configure_time_server_configure_sntp_server.htm"
                                        },
                                        
                                            {
                                                "name":"Add NTP Server",
                                                "pageUrl":"system_time_configure_time_server_add_ntp_server_show_ntp_server.htm"
                                            },
                                            {
                                                "name":"Show NTP Server",
                                                "pageUrl":"system_time_configure_time_server_add_ntp_server_show_ntp_server.htm"
                                            },
                                            {
                                                "name":"Add NTP Authentication Key",
                                                "pageUrl":"system_time_configure_time_server_add_ntp_authentication_key_show_ntp_authentication_key.htm"
                                            },
                                            {
                                                "name":"Show NTP Authentication Key",
                                                "pageUrl":"system_time_configure_time_server_add_ntp_authentication_key_show_ntp_authentication_key.htm"
                                            }
                                        
                                    ]
                                }
                            },
                            {
                                "name":"Configure Time Zone",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_time_configure_time_zone.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Summer Time",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_time_configure_summer_time.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"Console",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_console.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"Telnet",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_telnet.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"CPU Utilization",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "name":"Show Information",
                                            "pageUrl":"system_cpu_utilization.htm"
                                        },
                                        
                                            {
                                                "name":"Show Information by Task",
                                                "pageUrl":"system_cpu_utilization_task.htm"
                                            }
                                        
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"CPU Guard",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"system_cpu_guard.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"Memory Status",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_memory_status.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"Stacking",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        
                                        
                                        
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"Reset",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"system_reset.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                }
            ]
        },
        {
            "name":"Interface",
            "list":[
                {
                    "name":"Port",
                    "list":[
                        {
                            "name":"General",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "defaultValue":"Show Information",
                                            "list":[
                                                {
                                                    "name":"Show Information",
                                                    "pageUrl":"interface_port_general_show_information.htm",
                                                    "parameters":{
                                                        "unit":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Configure by Port List",
                                                    "pageUrl":"interface_port_general_configure_by_port_list.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "type":{
                                                            "defaultValue":"port"
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Configure by Port Range",
                                                    "pageUrl":"interface_port_general_configure_by_port_range.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "type":{
                                                            "defaultValue":"port"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Statistics",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "useTransferPage":true,
                                                    "pageUrl":"interface_port_statistics_interface.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ },
                                                        "autoRefresh":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Chart",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "useTransferPage":true,
                                                    "pageUrl":"interface_port_chart_interface.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ },
                                                        "autoRefresh":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        
                            {
                                "name":"History",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "useTransferPage":true,
                                                        "pageUrl":"interface_port_history_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "useTransferPage":true,
                                                        "pageUrl":"interface_port_history_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show Details",
                                                        "pageUrl":"interface_port_history_show_details_status.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{
                                                                "defaultValue":0
                                                            },
                                                            "STRPARAM":{
                                                                "defaultValue":"\"\""
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"Transceiver",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "useTransferPage":true,
                                                        "pageUrl":"interface_port_transceiver.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                        
                        
                            {
                                "name":"Cable Test",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"interface_port_cable_test_tdr.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                    ]
                },
                {
                    "name":"Trunk",
                    "list":[
                        {
                            "name":"Static",
                            "step":{
                                "list":[
                                    {
                                        "name":"Configure Trunk",
                                        "action":{
                                            "defaultValue":"Show",
                                            "list":[
                                                {
                                                    "name":"Add",
                                                    "pageUrl":"interface_trunk_static_configure_trunk_add_show.htm",
                                                    "parameters":{
                                                        "unit":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Show",
                                                    "pageUrl":"interface_trunk_static_configure_trunk_add_show.htm",
                                                    "parameters":{
                                                        "unit":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Add Member",
                                                    "pageUrl":"interface_trunk_static_configure_trunk_add_member_show_member.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "trunk_type":{
                                                            "defaultValue":"staticIncludeNull"
                                                        },
                                                        "port_type":{
                                                            "defaultValue":"normal"
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show Member",
                                                    "pageUrl":"interface_trunk_static_configure_trunk_add_member_show_member.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "trunk_type":{
                                                            "defaultValue":"staticIncludeNull"
                                                        },
                                                        "port_type":{
                                                            "defaultValue":"normal"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "name":"Configure General",
                                        "action":{
                                            "defaultValue":"Show Information",
                                            "list":[
                                                {
                                                    "name":"Show Information",
                                                    "pageUrl":"interface_trunk_static_configure_general_show_information.htm"
                                                },
                                                {
                                                    "name":"Configure",
                                                    "pageUrl":"interface_trunk_static_configure_general_configure.htm",
                                                    "parameters":{
                                                        "type":{
                                                            "defaultValue":"trunkStatic"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Dynamic",
                            "step":{
                                "list":[
                                    {
                                        "name":"Configure Aggregator",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"interface_trunk_dynamic_configure_aggregator.htm"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "name":"Configure Aggregation Port",
                                        "action":{
                                            "defaultValue":"Configure",
                                            "list":[
                                                {
                                                    "name":"Configure",
                                                    "pageUrl":"interface_trunk_dynamic_configure_aggregation_port_configure_general.htm",
                                                    "parameters":{
                                                        "unit":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Show Information",
                                                    "pageUrl":"interface_trunk_dynamic_configure_aggregation_port_show_information_counters.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port_type":{
                                                            "defaultValue":"dynamicTrunkMember"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "name":"Configure Trunk",
                                        "action":{
                                            "defaultValue":"Show",
                                            "list":[
                                                {
                                                    "name":"Show",
                                                    "pageUrl":"interface_trunk_dynamic_configure_trunk_show.htm"
                                                },
                                                {
                                                    "name":"Configure",
                                                    "pageUrl":"interface_trunk_dynamic_configure_trunk_configure.htm",
                                                    "parameters":{
                                                        "type":{
                                                            "defaultValue":"trunkDynamic"
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show Member",
                                                    "pageUrl":"interface_trunk_dynamic_configure_trunk_show_member.htm",
                                                    "parameters":{
                                                        "trunk_type":{
                                                            "defaultValue":"dynamic"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Statistics",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "useTransferPage":true,
                                                    "pageUrl":"interface_trunk_statistics_interface.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ },
                                                        "autoRefresh":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Chart",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "useTransferPage":true,
                                                    "pageUrl":"interface_trunk_chart_interface.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ },
                                                        "autoRefresh":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        
                            {
                                "name":"Load Balance",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"interface_trunk_load_balance.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"History",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "useTransferPage":true,
                                                        "pageUrl":"interface_trunk_history_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "useTransferPage":true,
                                                        "pageUrl":"interface_trunk_history_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show Details",
                                                        "pageUrl":"interface_trunk_history_show_details_status.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{
                                                                "defaultValue":0
                                                            },
                                                            "STRPARAM":{
                                                                "defaultValue":"\"\""
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                    ]
                },
                
                    {
                        "name":"Green Ethernet",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"interface_green_ethernet.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"Mirror",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "useTransferPage":true,
                                            "pageUrl":"interface_port_mirror_add_show.htm",
                                            "parameters":{
                                                "sUnit":{ },
                                                "tUnit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "useTransferPage":true,
                                            "pageUrl":"interface_port_mirror_add_show.htm",
                                            "parameters":{
                                                "sUnit":{ },
                                                "tUnit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"RSPAN",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"interface_rspan.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "session":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"sFlow",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Receiver",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Show",
                                                "pageUrl":"interface_sflow_configure_receiver_add_show.htm"
                                            },
                                            {
                                                "name":"Add",
                                                "pageUrl":"interface_sflow_configure_receiver_add_show.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Details",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Show",
                                                "pageUrl":"interface_sflow_configure_details_add_show_sampling.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "STRPARAM":{
                                                        "defaultValue":" "
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Add",
                                                "pageUrl":"interface_sflow_configure_details_add_show_sampling.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "STRPARAM":{
                                                        "defaultValue":" "
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"Traffic Segmentation",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"interface_traffic_segmentation_configure_global.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Session",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"interface_traffic_segmentation_configure_session_add_show.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"interface_traffic_segmentation_configure_session_add_show.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"VLAN Trunking",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"interface_vlan_trunking_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"VLAN",
            "list":[
                {
                    "name":"Static",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"vlan_static_add_show_modify.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"vlan_static_add_show_modify.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Modify",
                                            "pageUrl":"vlan_static_add_show_modify.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Edit Member by VLAN",
                                            "pageUrl":"vlan_static_edit_member_by_vlan_port.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "vlan_type":{
                                                    "defaultValue":"static"
                                                },
                                                "port_type":{
                                                    "defaultValue":"normal"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Edit Member by Interface",
                                            "pageUrl":"vlan_static_edit_member_by_interface_port.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "vlan_type":{
                                                    "defaultValue":"static"
                                                },
                                                "port_type":{
                                                    "defaultValue":"normal"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Edit Member by Interface Range",
                                            "pageUrl":"vlan_static_edit_member_by_interface_range.htm",
                                            "parameters":{
                                                "isTrunk":{
                                                    "defaultValue":"false"
                                                },
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Dynamic",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure General",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"vlan_dynamic_configure_general.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"vlan_dynamic_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Dynamic VLAN",
                                    "action":{
                                        "defaultValue":"Show VLAN",
                                        "list":[
                                            {
                                                "name":"Show VLAN",
                                                "pageUrl":"vlan_dynamic_show_dynamic_vlan_show_vlan.htm"
                                            },
                                            {
                                                "name":"Show VLAN Member",
                                                "pageUrl":"vlan_dynamic_show_dynamic_vlan_show_vlan_member.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "vlan_type":{
                                                        "defaultValue":"dynamic"
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                
                    {
                        "name":"Tunnel",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"vlan_tunnel_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                
                                    {
                                        "name":"Configure Service",
                                        "action":{
                                            "defaultValue":"Show",
                                            "list":[
                                                {
                                                    "name":"Add",
                                                    "useTransferPage":true,
                                                    "pageUrl":"vlan_tunnel_configure_service_add_show.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Show",
                                                    "useTransferPage":true,
                                                    "pageUrl":"vlan_tunnel_configure_service_add_show.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    },
                                
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"vlan_tunnel_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"L2PT",
                        "step":{
                            "list":[
                                
                                    {
                                        "name":"Configure Global",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"vlan_l2pt_configure_global.htm"
                                                }
                                            ]
                                        }
                                    },
                                
                                
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"vlan_l2pt_configure_interface.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"Protocol",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Protocol",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"vlan_protocol_configure_protocol_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"vlan_protocol_configure_protocol_add_show.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "useTransferPage":true,
                                                "pageUrl":"vlan_protocol_configure_interface_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "useTransferPage":true,
                                                "pageUrl":"vlan_protocol_configure_interface_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"IP Subnet",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Subnet VLAN",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"vlan_ip_subnet_configure_subnet_vlan_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"vlan_ip_subnet_configure_subnet_vlan_add_show.htm"
                                            }
                                        ]
                                    }
                                }
                                
                            ]
                        }
                    },
                
                
                    {
                        "name":"MAC-Based",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Show",
                                                "pageUrl":"vlan_mac_based_add_show.htm"
                                            },
                                            {
                                                "name":"Add",
                                                "pageUrl":"vlan_mac_based_add_show.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                
                
                    {
                        "name":"Translation",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "useTransferPage":true,
                                                "pageUrl":"vlan_translation_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "useTransferPage":true,
                                                "pageUrl":"vlan_translation_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"MAC Address",
            "list":[
                {
                    "name":"Dynamic",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Show Dynamic MAC",
                                    "list":[
                                        {
                                            "name":"Show Dynamic MAC",
                                            "useTransferPage":true,
                                            "pageUrl":"mac_address_dynamic_show_dynamic_mac.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "STRPARAM":{
                                                    "defaultValue":"1_0_0_0_0_0_0"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Clear Dynamic MAC",
                                            "pageUrl":"mac_address_dynamic_clear_dynamic_mac.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Configure Aging",
                                            "pageUrl":"mac_address_dynamic_configure_aging.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Learning Status",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "name":"Configure Interface",
                                                "pageUrl":"mac_address_learning_status_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                            
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"Static",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "useTransferPage":true,
                                            "pageUrl":"mac_address_static_add_show.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "STRPARAM":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "useTransferPage":true,
                                            "pageUrl":"mac_address_static_add_show.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "STRPARAM":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
            
                    {
                        "name":"MAC Notification",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"mac_address_notification_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"mac_address_notification_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"Spanning Tree",
            "list":[
                
                    {
                        "name":"Loopback Detection",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"spanning_tree_loopback_detection_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"STA",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "defaultValue":"Show Information",
                                    "list":[
                                        {
                                            "name":"Show Information",
                                            "pageUrl":"spanning_tree_sta_configure_global_show_information.htm"
                                        },
                                        {
                                            "name":"Configure",
                                            "pageUrl":"spanning_tree_sta_configure_global_configure.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Interface",
                                "action":{
                                    "defaultValue":"Show Information",
                                    "list":[
                                        {
                                            "name":"Show Information",
                                            "pageUrl":"spanning_tree_sta_configure_interface_show_information_port.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Configure",
                                            "pageUrl":"spanning_tree_sta_configure_interface_configure_port.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"MSTP",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"spanning_tree_mstp_configure_global_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"spanning_tree_mstp_configure_global_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Modify",
                                            "pageUrl":"spanning_tree_mstp_configure_global_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Show Information",
                                            "pageUrl":"spanning_tree_mstp_configure_global_show_information.htm",
                                            "parameters":{
                                                "mstId":{
                                                    "defaultValue":0
                                                }
                                            }
                                        },
                                        {
                                            "name":"Add Member",
                                            "pageUrl":"spanning_tree_mstp_configure_global_add_member_show_member.htm",
                                            "parameters":{
                                                "mstId":{
                                                    "defaultValue":0
                                                }
                                            }
                                        },
                                        {
                                            "name":"Show Member",
                                            "pageUrl":"spanning_tree_mstp_configure_global_add_member_show_member.htm",
                                            "parameters":{
                                                "mstId":{
                                                    "defaultValue":0
                                                }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Interface",
                                "action":{
                                    "defaultValue":"Show Information",
                                    "list":[
                                        {
                                            "name":"Show Information",
                                            "pageUrl":"spanning_tree_mstp_configure_interface_show_information_port.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "mstId":{
                                                    "defaultValue":0
                                                }
                                            }
                                        },
                                        {
                                            "name":"Configure",
                                            "pageUrl":"spanning_tree_mstp_configure_interface_configure_port.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "mstId":{
                                                    "defaultValue":0
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                }
            ]
        },
        {
            "name":"Traffic",
            "list":[
                
                    {
                        "name":"Rate Limit",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"traffic_rate_limit_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"Storm Control",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        
                                        {
                                            "name":"Configure Interface",
                                            "pageUrl":"traffic_storm_control_port.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Auto Traffic Control",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"traffic_auto_traffic_control_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"traffic_auto_traffic_control_configure_interface_broadcast.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"Priority",
                    "list":[
                        {
                            "name":"Default Priority",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"traffic_priority_default_priority_port.htm",
                                                    "parameters":{
                                                        "unit":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        
                            
                                {
                                    "name":"Queue",
                                    "step":{
                                        "list":[
                                            {
                                                "action":{
                                                    "list":[
                                                        {
                                                            "useTransferPage":true,
                                                            "pageUrl":"traffic_priority_queue_port.htm",
                                                            "parameters":{
                                                                "unit":{ },
                                                                "port":{
                                                                    "defaultValue":1
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                },
                            
                            
                        
                        
                            {
                                "name":"Trust Mode",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"traffic_priority_trust_mode_port.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                        
                        
                            {
                                "name":"CoS to Queue",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    
                                                        {
                                                            "useTransferPage":true,
                                                            "pageUrl":"traffic_priority_cos_to_queue_port.htm",
                                                            "parameters":{
                                                                "unit":{ },
                                                                "port":{ }
                                                            }
                                                        }
                                                    
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"DSCP to Queue",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    
                                                        {
                                                            "useTransferPage":true,
                                                            "pageUrl":"traffic_priority_dscp_to_queue_port.htm",
                                                            "parameters":{
                                                                "unit":{ },
                                                                "port":{ }
                                                            }
                                                        }
                                                    
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                        
                        
                        
                        
                        
                        
                    ]
                },
                {
                    "name":"DiffServ",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Class",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"traffic_diffserv_configure_class_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"traffic_diffserv_configure_class_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Modify",
                                            "pageUrl":"traffic_diffserv_configure_class_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Add Rule",
                                            "pageUrl":"traffic_diffserv_configure_class_add_rule_show_rule.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show Rule",
                                            "pageUrl":"traffic_diffserv_configure_class_add_rule_show_rule.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Policy",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"traffic_diffserv_configure_policy_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"traffic_diffserv_configure_policy_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Modify",
                                            "pageUrl":"traffic_diffserv_configure_policy_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Add Rule",
                                            "pageUrl":"traffic_diffserv_configure_policy_add_rule_show_rule.htm"
                                        },
                                        {
                                            "name":"Show Rule",
                                            "pageUrl":"traffic_diffserv_configure_policy_add_rule_show_rule.htm"
                                        }
                                        
                                    ]
                                }
                            },
                            {
                                "name":"Configure Interface",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"traffic_diffserv_configure_interface.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"VoIP",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"traffic_voip_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure OUI",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"traffic_voip_configure_oui_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"traffic_voip_configure_oui_add_show.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"traffic_voip_configure_interface.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"Security",
            "list":[
                {
                    "name":"AAA",
                    "list":[
                        
                            {
                                "name":"System Authentication",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_system_authentication.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Server",
                                "step":{
                                    "list":[
                                        {
                                            "name":"Configure Server",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_server_configure_server_radius.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        
                                            {
                                                "name":"Configure Group",
                                                "action":{
                                                    "defaultValue":"Show",
                                                    "list":[
                                                        {
                                                            "name":"Add",
                                                            "pageUrl":"security_aaa_server_configure_group_radius.htm"
                                                        },
                                                        {
                                                            "name":"Show",
                                                            "pageUrl":"security_aaa_server_configure_group_radius.htm"
                                                        }
                                                    ]
                                                }
                                            }
                                        
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"Accounting",
                                "step":{
                                    "list":[
                                        {
                                            "name":"Configure Global",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_accounting_configure_global.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Configure Method",
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"security_aaa_accounting_configure_method_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"security_aaa_accounting_configure_method_add_show.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Configure Service",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_accounting_configure_service_dot1x.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Show Information",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_accounting_show_information_summary.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"Authorization",
                                "step":{
                                    "list":[
                                        {
                                            "name":"Configure Method",
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"security_aaa_authorization_configure_method_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"security_aaa_authorization_configure_method_add_show.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Configure Service",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_authorization_configure_service.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Show Information",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_aaa_authorization_show_information.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                    ]
                },
                {
                    "name":"User Accounts",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"security_user_accounts_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"security_user_accounts_add_show_modify.htm"
                                        },
                                        {
                                            "name":"Modify",
                                            "pageUrl":"security_user_accounts_add_show_modify.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Web Authentication",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_web_authentication_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"security_web_authentication_configure_interface.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"Network Access",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_network_access_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_network_access_configure_interface_general.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure MAC Filter",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"security_network_access_configure_mac_filter_add_show.htm",
                                                "parameters":{
                                                    "filterId":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"security_network_access_configure_mac_filter_add_show.htm",
                                                "parameters":{
                                                    "filterId":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Information",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_network_access_show_information.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "STRPARAM":{
                                                        "defaultValue":"1_0_0_0_0_0_0"
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"HTTPS",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Configure Global",
                                    "list":[
                                        {
                                            "name":"Configure Global",
                                            "pageUrl":"security_https_configure_global.htm"
                                        },
                                        {
                                            "name":"Copy Certificate",
                                            "pageUrl":"security_https_copy_certificate.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"SSH",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"security_ssh_configure_global.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Host Key",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Generate",
                                            "pageUrl":"security_ssh_configure_host_key_generate_show.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"security_ssh_configure_host_key_generate_show.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure User Key",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Copy",
                                            "useTransferPage":true,
                                            "pageUrl":"security_ssh_configure_user_key_copy_show.htm",
                                            "parameters":{
                                                "STRPARAM":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "useTransferPage":true,
                                            "pageUrl":"security_ssh_configure_user_key_copy_show.htm",
                                            "parameters":{
                                                "STRPARAM":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"ACL",
                    "step":{
                        "defaultValue":"Configure ACL",
                        "list":[
                            {
                                "name":"Configure ACL",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Show TCAM",
                                            "pageUrl":"security_acl_configure_acl_show_tcam.htm"
                                        },
                                        {
                                            "name":"Add",
                                            "pageUrl":"security_acl_configure_acl_add_show.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"security_acl_configure_acl_add_show.htm"
                                        },
                                        {
                                            "name":"Add Rule",
                                            "pageUrl":"security_acl_configure_acl_add_rule_ip_standard.htm",
                                            "parameters":{
                                                "acl_type":{
                                                    "defaultValue":"ipv4Std"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Show Rule",
                                            "pageUrl":"security_acl_configure_acl_show_rule_ip_standard.htm",
                                            "parameters":{
                                                "acl_type":{
                                                    "defaultValue":"ipv4Std"
                                                }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Interface",
                                "action":{
                                    "list":[
                                        {
                                            "name":"Configure",
                                            "useTransferPage":true,
                                            "pageUrl":"security_acl_configure_interface_ip.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "port":{
                                                    "defaultValue":0
                                                }
                                            }
                                        },
                                        
                                        
                                            {
                                                "name":"Show Hardware Counter",
                                                "pageUrl":"security_acl_configure_interface_show_hardware_counter.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port_type":{
                                                        "defaultValue":"normal"
                                                    }
                                                }
                                            }
                                        
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"IP Filter",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"security_ip_filter_add_show_web.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"security_ip_filter_add_show_web.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Port Security",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_port_security.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"Port Authentication",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_port_authentication_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"security_port_authentication_configure_interface_authenticator.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Statistics",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"security_port_authentication_show_statistics_authenticator.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"DoS Protection",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_dos_protection.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"DHCP Snooping",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_dhcp_snooping_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure VLAN",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"ip_service_dhcp_snooping_configure_vlan.htm",
                                                "parameters":{
                                                    "vlan":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_dhcp_snooping_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Information",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_dhcp_snooping_show_information.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"DHCP Snooping6",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_dhcp_snooping6_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure VLAN",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"ip_service_dhcp_snooping6_configure_vlan.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"ip_service_dhcp_snooping6_configure_vlan.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_dhcp_snooping6_configure_interface.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Information",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_dhcp_snooping6_show_information_binding.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"IP Source Guard",
                        "list":[
                            {
                                "name":"General",
                                "step":{
                                    "list":[
                                        
                                        {
                                            "name":"Configure Interface",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_ip_source_guard_port_configuration.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Static Binding",
                                "step":{
                                    "list":[
                                        {
                                            "name":"Configure ACL Table",
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"security_ip_source_guard_static_binding_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"security_ip_source_guard_static_binding_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        },
                                        
                                            {
                                                "name":"Configure MAC Table",
                                                "action":{
                                                    "defaultValue":"Show",
                                                    "list":[
                                                        {
                                                            "name":"Add",
                                                            "pageUrl":"security_ip_source_guard_static_binding_configure_mac_table_add_show.htm",
                                                            "parameters":{
                                                                "unit":{ }
                                                            }
                                                        },
                                                        {
                                                            "name":"Show",
                                                            "pageUrl":"security_ip_source_guard_static_binding_configure_mac_table_add_show.htm",
                                                            "parameters":{
                                                                "unit":{ }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        
                                    ]
                                }
                            },
                            {
                                "name":"Dynamic Binding",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "useTransferPage":true,
                                                        "pageUrl":"security_ip_source_guard_dynamic_binding.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "STRPARAM":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                
                
                    {
                        "name":"IPv6 Source Guard",
                        "list":[
                            {
                                "name":"Port Configuration",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"security_ipv6_source_guard_port_configuration.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Static Binding",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"security_ipv6_source_guard_static_binding_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"security_ipv6_source_guard_static_binding_add_show.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Dynamic Binding",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "useTransferPage":true,
                                                        "pageUrl":"security_ipv6_source_guard_dynamic_binding.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "STRPARAM":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                
                
                    {
                        "name":"ARP Inspection",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure General",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_arp_inspection_configure_general.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure VLAN",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_arp_inspection_configure_vlan.htm",
                                                "parameters":{
                                                    "acl_type":{
                                                        "defaultValue":"arp"
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_arp_inspection_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Information",
                                    "action":{
                                        "defaultValue":"Show Statistics",
                                        "list":[
                                            {
                                                "name":"Show Statistics",
                                                "pageUrl":"security_arp_inspection_show_information_show_statistics_show_log.htm"
                                            },
                                            {
                                                "name":"Show Log",
                                                "pageUrl":"security_arp_inspection_show_information_show_statistics_show_log.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"Application Filter",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"security_application_filter.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"Administration",
            "list":[
                {
                    "name":"Log",
                    "list":[
                        {
                            "name":"System",
                            "step":{
                                "list":[
                                    {
                                        "name":"Show System Logs",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"administration_log_system_show_system_logs_ram_flash.htm"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "name":"Configure Global",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"administration_log_system_configure_global.htm"
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Remote",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"administration_log_remote.htm"
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        
                            {
                                "name":"SMTP",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"administration_log_smtp.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                    ]
                },
                {
                    "name":"LLDP",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"administration_lldp_configure_global.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Interface",
                                "action":{
                                    "defaultValue":"Configure General",
                                    "list":[
                                        {
                                            "name":"Configure General",
                                            "pageUrl":"administration_lldp_configure_interface_port.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "port_type":{
                                                    "defaultValue":"normal"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Add CA-Type",
                                            "pageUrl":"administration_lldp_configure_interface_port_add_ca_type.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "port_type":{
                                                    "defaultValue":"normal"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Show CA-Type",
                                            "pageUrl":"administration_lldp_configure_interface_port_show_ca_type.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "port_type":{
                                                    "defaultValue":"normal"
                                                }
                                            }
                                        },
                                        {
                                            "name":"Modify CA-Type",
                                            "pageUrl":"administration_lldp_configure_interface_port_modify_ca_type.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "port_type":{
                                                    "defaultValue":"normal"
                                                }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Show Local Device Information",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"administration_lldp_show_local_device_information_general.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Show Remote Device Information",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"administration_lldp_show_remote_device_information_port.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Show Device Statistics",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"administration_lldp_show_device_statistics_general.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"PoE",
                    "list":[
                        
                            {
                                "name":"PSE",
                                "step":{
                                    "list":[
                                        
                                            {
                                                "name":"Configure Global",
                                                "action":{
                                                    "list":[
                                                        {
                                                            "pageUrl":"administration_poe_pse_configure_global.htm",
                                                            "parameters":{
                                                                "unit":{ }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                        
                                        
                                        {
                                            "name":"Configure Interface",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"administration_poe_pse_configure_interface.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                        
                    ]
                },
                {
                    "name":"SNMP",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"administration_snmp_configure_global.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Community",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Show",
                                            "pageUrl":"administration_snmp_configure_user_add_community_show_community.htm"
                                        },
                                        {
                                            "name":"Add",
                                            "pageUrl":"administration_snmp_configure_user_add_community_show_community.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Engine",
                                "action":{
                                    "defaultValue":"Set Engine ID",
                                    "list":[
                                        {
                                            "name":"Set Engine ID",
                                            "pageUrl":"administration_snmp_configure_engine_set_engine_id.htm"
                                        },
                                        {
                                            "name":"Add Remote Engine",
                                            "pageUrl":"administration_snmp_configure_engine_add_remote_engine_show_remote_engine.htm"
                                        },
                                        {
                                            "name":"Show Remote Engine",
                                            "pageUrl":"administration_snmp_configure_engine_add_remote_engine_show_remote_engine.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure View",
                                "action":{
                                    "defaultValue":"Show View",
                                    "list":[
                                        {
                                            "name":"Add View",
                                            "pageUrl":"administration_snmp_configure_view_add_view_show_view.htm"
                                        },
                                        {
                                            "name":"Show View",
                                            "pageUrl":"administration_snmp_configure_view_add_view_show_view.htm"
                                        },
                                        {
                                            "name":"Add OID Subtree",
                                            "pageUrl":"administration_snmp_configure_view_add_oid_subtree_show_oid_subtree.htm"
                                        },
                                        {
                                            "name":"Show OID Subtree",
                                            "pageUrl":"administration_snmp_configure_view_add_oid_subtree_show_oid_subtree.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Group",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"administration_snmp_configure_group_add_show.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"administration_snmp_configure_group_add_show.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure User",
                                "action":{
                                    "defaultValue":"Add SNMPv3 Local User",
                                    "list":[
                                        {
                                            "name":"Add SNMPv3 Local User",
                                            "pageUrl":"administration_snmp_configure_user_add_snmpv3_local_user_show_snmpv3_local_user.htm"
                                        },
                                        {
                                            "name":"Show SNMPv3 Local User",
                                            "pageUrl":"administration_snmp_configure_user_add_snmpv3_local_user_show_snmpv3_local_user.htm"
                                        },
                                        {
                                            "name":"Change SNMPv3 Local User Group",
                                            "pageUrl":"administration_snmp_configure_user_change_snmpv3_local_user_group.htm"
                                        },
                                        {
                                            "name":"Add SNMPv3 Remote User",
                                            "pageUrl":"administration_snmp_configure_user_add_snmpv3_remote_user_show_snmpv3_remote_user.htm"
                                        },
                                        {
                                            "name":"Show SNMPv3 Remote User",
                                            "pageUrl":"administration_snmp_configure_user_add_snmpv3_remote_user_show_snmpv3_remote_user.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Trap",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"administration_snmp_configure_trap_add_show.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"administration_snmp_configure_trap_add_show.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Notify Filter",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"administration_snmp_configure_notify_filter_add_show.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"administration_snmp_configure_notify_filter_add_show.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Show Statistics",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"administration_snmp_show_statistics.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                {
                    "name":"RMON",
                    "step":{
                        "list":[
                            {
                                "name":"Configure Global",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"administration_rmon_configure_global_add_show_alarm.htm"
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"administration_rmon_configure_global_add_show_alarm.htm"
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Configure Interface",
                                "action":{
                                    "defaultValue":"Show",
                                    "list":[
                                        {
                                            "name":"Add",
                                            "pageUrl":"administration_rmon_configure_interface_add_show_history.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show",
                                            "pageUrl":"administration_rmon_configure_interface_add_show_history.htm",
                                            "parameters":{
                                                "unit":{ }
                                            }
                                        },
                                        {
                                            "name":"Show Details",
                                            "pageUrl":"administration_rmon_configure_interface_show_detail_history.htm",
                                            "parameters":{
                                                "unit":{ },
                                                "info_type":{
                                                    "defaultValue":"detail"
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Cluster",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_cluster_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Member",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"administration_cluster_configure_member_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"administration_cluster_configure_member_add_show.htm"
                                            },
                                            {
                                                "name":"Show Candidate",
                                                "pageUrl":"administration_cluster_configure_member_show_candidate.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Member",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_cluster_show_member.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"Time Range",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"administration_time_range_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"administration_time_range_add_show.htm"
                                            },
                                            {
                                                "name":"Add Rule",
                                                "pageUrl":"administration_time_range_add_rule.htm"
                                            },
                                            {
                                                "name":"Show Rule",
                                                "pageUrl":"administration_time_range_show_rule.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"ERPS",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_erps_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Domain",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"administration_erps_configure_domain_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"administration_erps_configure_domain_add_show.htm"
                                            },
                                            {
                                                "name":"Configure Details",
                                                "pageUrl":"administration_erps_configure_domain_configure_details.htm",
                                                "parameters":{
                                                    "STRPARAM":{
                                                        "defaultValue":" "
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Configure Operation",
                                                "pageUrl":"administration_erps_configure_domain_configure_operation.htm",
                                                "parameters":{
                                                    "STRPARAM":{
                                                        "defaultValue":" "
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Statistics",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_erps_show_statistics.htm",
                                                "parameters":{
                                                    "STRPARAM":{
                                                        "defaultValue":" "
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"CFM",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_cfm_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_cfm_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure MD",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"administration_cfm_configure_md_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"administration_cfm_configure_md_add_show.htm"
                                            },
                                            {
                                                "name":"Configure Details",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_md_configure_details.htm",
                                                "parameters":{
                                                    "mdIndex":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure MA",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_ma_add_show.htm",
                                                "parameters":{
                                                    "mdIndex":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_ma_add_show.htm",
                                                "parameters":{
                                                    "mdIndex":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Configure Details",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_ma_configure_details.htm",
                                                "parameters":{
                                                    "mdIndex":{
                                                        "defaultValue":0
                                                    },
                                                    "maIndex":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure MEP",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_mep_add_show.htm",
                                                "parameters":{
                                                    "mdIndex":{ },
                                                    "maIndex":{ }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_mep_add_show.htm",
                                                "parameters":{
                                                    "mdIndex":{ },
                                                    "maIndex":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Remote MEP",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_remote_mep_add_show.htm",
                                                "parameters":{
                                                    "mdIndex":{ },
                                                    "maIndex":{ }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_configure_remote_mep_add_show.htm",
                                                "parameters":{
                                                    "mdIndex":{ },
                                                    "maIndex":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Transmit Link Trace",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_transmit_link_trace.htm",
                                                "parameters":{
                                                    "mdIndex":{ },
                                                    "maIndex":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Transmit Loopback",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_transmit_loopback.htm",
                                                "parameters":{
                                                    "mdIndex":{ },
                                                    "maIndex":{ },
                                                    "STRPARAM":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                
                                    {
                                        "name":"Transmit Delay Measure",
                                        "action":{
                                            "list":[
                                                {
                                                    "useTransferPage":true,
                                                    "pageUrl":"administration_cfm_transmit_delay_measure.htm",
                                                    "parameters":{
                                                        "mdIndex":{ },
                                                        "maIndex":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    },
                                
                                {
                                    "name":"Show Information",
                                    "action":{
                                        "defaultValue":"Show Local MEP",
                                        "list":[
                                            {
                                                "name":"Show Local MEP",
                                                "pageUrl":"administration_cfm_show_information_show_local_mep.htm"
                                            },
                                            {
                                                "name":"Show Local MEP Details",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_show_information_show_local_mep_details.htm",
                                                "parameters":{
                                                    "mdIndex":{
                                                        "defaultValue":0
                                                    },
                                                    "maIndex":{
                                                        "defaultValue":0
                                                    },
                                                    "mepId":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show Local MIP",
                                                "pageUrl":"administration_cfm_show_information_show_local_mip.htm"
                                            },
                                            {
                                                "name":"Show Remote MEP",
                                                "pageUrl":"administration_cfm_show_information_show_remote_mep.htm"
                                            },
                                            {
                                                "name":"Show Remote MEP Details",
                                                "useTransferPage":true,
                                                "pageUrl":"administration_cfm_show_information_show_remote_mep_details.htm",
                                                "parameters":{
                                                    "mdIndex":{
                                                        "defaultValue":0
                                                    },
                                                    "maIndex":{
                                                        "defaultValue":0
                                                    },
                                                    "mepId":{
                                                        "defaultValue":0
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show Link Trace Cache",
                                                "pageUrl":"administration_cfm_show_information_show_link_trace_cache.htm"
                                            },
                                            {
                                                "name":"Show Fault Notification Generator",
                                                "pageUrl":"administration_cfm_show_information_show_fault_notification_generator.htm"
                                            },
                                            {
                                                "name":"Show Continuity Check Error",
                                                "pageUrl":"administration_cfm_show_information_show_show_continuity_check_error.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"OAM",
                        "list":[
                            {
                                "name":"Interface",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"administration_oam_interface.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Counters",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"administration_oam_counters.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Event Log",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "useTransferPage":true,
                                                        "pageUrl":"administration_oam_event_log.htm",
                                                        "parameters":{
                                                            "unit":{ },
                                                            "port":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Remote Interface",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"administration_oam_remote_interface.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            
                                {
                                    "name":"Remote Loopback",
                                    "step":{
                                        "list":[
                                            {
                                                "action":{
                                                    "defaultValue":"Show Test Result",
                                                    "list":[
                                                        {
                                                            "name":"Show Test Result",
                                                            "pageUrl":"administration_oam_remote_loopback_show_test_result.htm",
                                                            "parameters":{
                                                                "unit":{ }
                                                            }
                                                        },
                                                        {
                                                            "name":"Remote Loopback Test",
                                                            "pageUrl":"administration_oam_remote_loopback_remote_loopback_test.htm",
                                                            "parameters":{
                                                                "unit":{ },
                                                                "port":{
                                                                    "defaultValue":0
                                                                },
                                                                "STRPARAM":{
                                                                    "defaultValue":" "
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                }
                            
                        ]
                    },
                
                
                    {
                        "name":"UDLD",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_udld_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_udld_configure_interface.htm",
                                                "parameters":{
                                                "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Information",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_udld_show.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port_type":{
                                                        "defaultValue":"normal"
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"LBD",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_lbd_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"administration_lbd_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"Tools",
            "list":[
                {
                    "name":"Ping",
                    "step":{
                        "list":[
                            {
                                "action":{
                                    "list":[
                                        {
                                            "useTransferPage":true,
                                            "pageUrl":"ip_general_ping.htm",
                                            "parameters":{
                                                "STRPARAM":{ }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                },
                
                    {
                        "name":"Trace Route",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_general_trace_route.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"ARP",
                    "step":{
                        "list":[
                            
                                {
                                    "name":"Configure General",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"ip_arp_configure_general.htm",
                                                "parameters":{
                                                    "vlan":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                            
                            
                                {
                                    "name":"Configure Static Address",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"ip_arp_configure_static_address_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"ip_arp_configure_static_address_add_show.htm"
                                            }
                                        ]
                                    }
                                },
                            
                            {
                                "name":"Show Information",
                                "action":{
                                    "list":[
                                        {
                                            "pageUrl":"ip_arp_show_information_dynamin_address.htm"
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                }
            ]
        },
        {
            "name":"IP",
            "list":[
                {
                    "name":"General",
                    "list":[
                        
                            {
                                "name":"Routing Interface",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show Address",
                                                "list":[
                                                    {
                                                        "name":"Add Address",
                                                        "pageUrl":"ip_general_routing_interface_add_address.htm"
                                                    },
                                                    
                                                    {
                                                        "name":"Show Address",
                                                        "pageUrl":"ip_general_routing_interface_show_address.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                    ]
                },
                
                    {
                        "name":"Routing",
                        "list":[
                            {
                                "name":"Static Routes",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"ip_routing_static_routes_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"ip_routing_static_routes_add_show.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Routing Table",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show Information",
                                                "list":[
                                                    {
                                                        "name":"Show Information",
                                                        "pageUrl":"ip_routing_routing_table.htm"
                                                    }
                                                    
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                
                
                
                    {
                        "name":"IPv6 Configuration",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "defaultValue":"Configure Global",
                                        "list":[
                                            {
                                                "name":"Configure Global",
                                                "pageUrl":"ip_ipv6_configuration_configure_global.htm"
                                            },
                                            {
                                                "name":"Configure Interface",
                                                "pageUrl":"ip_ipv6_configuration_configure_interface_vlan_ra_guard_port_trunk.htm"
                                            },
                                            {
                                                "name":"Add IPv6 Address",
                                                "pageUrl":"ip_ipv6_configuration_add_ipv6_address.htm"
                                            },
                                            {
                                                "name":"Show IPv6 Address",
                                                "pageUrl":"ip_ipv6_configuration_show_ipv6_address.htm"
                                            },
                                            {
                                                "name":"Show IPv6 Neighbor Cache",
                                                "pageUrl":"ip_ipv6_configuration_show_ipv6_neighbor_cache.htm"
                                            },
                                            {
                                                "name":"Show Statistics",
                                                "pageUrl":"ip_ipv6_configuration_show_statistics_ipv6.htm"
                                            },
                                            {
                                                "name":"Show MTU",
                                                "pageUrl":"ip_ipv6_configuration_show_mtu.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"IP Service",
            "list":[
                
                    {
                        "name":"DNS",
                        "list":[
                            {
                                "name":"General",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Configure Global",
                                                "list":[
                                                    {
                                                        "name":"Configure Global",
                                                        "pageUrl":"ip_service_dns_general_configure_global.htm"
                                                    },
                                                    {
                                                        "name":"Add Domain Name",
                                                        "pageUrl":"ip_service_dns_general_add_domain_name_show_domain_names.htm"
                                                    },
                                                    {
                                                        "name":"Show Domain Names",
                                                        "pageUrl":"ip_service_dns_general_add_domain_name_show_domain_names.htm"
                                                    },
                                                    {
                                                        "name":"Add Name Server",
                                                        "pageUrl":"ip_service_dns_general_add_name_server_show_name_servers.htm"
                                                    },
                                                    {
                                                        "name":"Show Name Servers",
                                                        "pageUrl":"ip_service_dns_general_add_name_server_show_name_servers.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Static Host Table",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"ip_service_dns_static_host_table_add_show_modify.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"ip_service_dns_static_host_table_add_show_modify.htm"
                                                    },
                                                    {
                                                        "name":"Modify",
                                                        "pageUrl":"ip_service_dns_static_host_table_add_show_modify.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Cache",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dns_cache.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                
                
                    {
                        "name":"Multicast DNS",
                        "step":{
                            "list":[
                                {
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_mdns.htm"
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                {
                    "name":"DHCP",
                    "list":[
                        {
                            "name":"Client",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "useTransferPage":true,
                                                    "pageUrl":"ip_service_dhcp_client.htm",
                                                    "parameters":{
                                                        "vlan":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        
                            {
                                "name":"Relay",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dhcp_relay_l2l3_combined.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"L3 Relay",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dhcp_relay.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"L2 Relay",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dhcp_relay_option82.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"Dynamic Provision",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dhcp_dynamic_provision.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                        
                        
                            {
                                "name":"Server",
                                "step":{
                                    "list":[
                                        {
                                            "name":"Configure Global",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dhcp_server_configure_global.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Configure Excluded Address",
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"ip_service_dhcp_server_configure_excluded_address_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"ip_service_dhcp_server_configure_excluded_address_add_show.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Configure Pool",
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"ip_service_dhcp_server_configure_pool_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"ip_service_dhcp_server_configure_pool_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Configure Detail",
                                                        "pageUrl":"ip_service_dhcp_server_configure_pool_configure_detail.htm"
                                                    }
                                                ]
                                            }
                                        },
                                        {
                                            "name":"Show IP Binding",
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"ip_service_dhcp_server_show_ip_binding.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        
                    ]
                },
                
                    {
                        "name":"DHCPv6",
                        "list":[
                            {
                                "name":"Relay",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Add",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"ip_service_dhcpv6_relay_add.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"ip_service_dhcpv6_relay_show.htm",
                                                        "parameters":{
                                                            "vlan":{
                                                                "defaultValue":0
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                
                
                
                    {
                        "name":"PPPoE Intermediate Agent",
                        "step":{
                            "list":[
                                {
                                    "name":"Configure Global",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_pppoe_intermediate_agent_configure_global.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_pppoe_intermediate_agent_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Statistics",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"ip_service_pppoe_intermediate_agent_show_statistics_port.htm",
                                                "parameters":{
                                                    "unit":{ }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"Multicast",
            "list":[
                {
                    "name":"IGMP Snooping",
                    "list":[
                        {
                            "name":"General",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"multicast_igmp_snooping_general.htm"
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Multicast Router",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "defaultValue":"Show Current Multicast Router",
                                            "list":[
                                                {
                                                    "name":"Add Static Multicast Router",
                                                    "pageUrl":"multicast_igmp_snooping_multicast_router_add_static_multicast_router_show_static_multicast_router.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "router_type":{
                                                            "defaultValue":"static"
                                                        },
                                                        "port_type":{
                                                            "defaultValue":"normal"
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show Static Multicast Router",
                                                    "pageUrl":"multicast_igmp_snooping_multicast_router_add_static_multicast_router_show_static_multicast_router.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "router_type":{
                                                            "defaultValue":"static"
                                                        },
                                                        "port_type":{
                                                            "defaultValue":"normal"
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show Current Multicast Router",
                                                    "pageUrl":"multicast_igmp_snooping_multicast_router_show_current_multicast_router.htm",
                                                    "parameters":{
                                                        "vlan_type":{
                                                            "defaultValue":"static"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"IGMP Member",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "defaultValue":"Show Static Member",
                                            "list":[
                                                {
                                                    "name":"Add Static Member",
                                                    "useTransferPage":true,
                                                    "pageUrl":"multicast_igmp_snooping_igmp_member_add_static_member_show_static_member.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "vlan":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Show Static Member",
                                                    "useTransferPage":true,
                                                    "pageUrl":"multicast_igmp_snooping_igmp_member_add_static_member_show_static_member.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "vlan":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Interface",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "defaultValue":"Show VLAN Information",
                                            "list":[
                                                {
                                                    "name":"Configure VLAN",
                                                    "pageUrl":"multicast_igmp_snooping_interface_configure_vlan.htm",
                                                    "parameters":{
                                                        "vlan_type":{
                                                            "defaultValue":"static"
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show VLAN Information",
                                                    "pageUrl":"multicast_igmp_snooping_interface_show_vlan_information.htm"
                                                },
                                                
                                                    {
                                                        "name":"Configure Interface",
                                                        "pageUrl":"multicast_igmp_snooping_interface_configure_interface_port.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    }
                                                
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Forwarding Entry",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"multicast_igmp_snooping_forwarding_entry.htm"
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Filter",
                            "step":{
                                "list":[
                                    {
                                        "name":"Configure General",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"multicast_igmp_snooping_filter_configure_general.htm"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "name":"Configure Profile",
                                        "action":{
                                            "defaultValue":"Show",
                                            "list":[
                                                {
                                                    "name":"Add",
                                                    "pageUrl":"multicast_igmp_snooping_filter_configure_profile_add_show.htm"
                                                },
                                                {
                                                    "name":"Show",
                                                    "pageUrl":"multicast_igmp_snooping_filter_configure_profile_add_show.htm"
                                                },
                                                {
                                                    "name":"Add Multicast Group Range",
                                                    "pageUrl":"multicast_igmp_snooping_filter_configure_profile_add_multicast_group_range_show_multicast_group_range.htm"
                                                },
                                                {
                                                    "name":"Show Multicast Group Range",
                                                    "pageUrl":"multicast_igmp_snooping_filter_configure_profile_add_multicast_group_range_show_multicast_group_range.htm"
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "name":"Configure Interface",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"multicast_igmp_snooping_filter_configure_interface_port.htm",
                                                    "parameters":{
                                                        "unit":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            "name":"Statistics",
                            "step":{
                                "list":[
                                    {
                                        "action":{
                                            "defaultValue":"Show Query Statistics",
                                            "list":[
                                                {
                                                    "name":"Show Query Statistics",
                                                    "useTransferPage":true,
                                                    "pageUrl":"multicast_igmp_snooping_statistics_show_query_statistics.htm",
                                                    "parameters":{
                                                        "vlan":{
                                                            "defaultValue":1
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show VLAN Statistics",
                                                    "pageUrl":"multicast_igmp_snooping_statistics_show_vlan_statistics.htm",
                                                    "parameters":{
                                                        "vlan":{
                                                            "defaultValue":1
                                                        }
                                                    }
                                                },
                                                {
                                                    "name":"Show Port Statistics",
                                                    "useTransferPage":true,
                                                    "pageUrl":"multicast_igmp_snooping_statistics_show_port_statistics.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ }
                                                    }
                                                },
                                                {
                                                    "name":"Show Trunk Statistics",
                                                    "useTransferPage":true,
                                                    "pageUrl":"multicast_igmp_snooping_statistics_show_trunk_statistics.htm",
                                                    "parameters":{
                                                        "unit":{ },
                                                        "port":{ }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        }
                    ]
                },
                
                    {
                        "name":"MLD Snooping",
                        "list":[
                            {
                                "name":"General",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"multicast_mld_snooping_general.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Interface",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "useTransferPage":true,
                                                        "pageUrl":"multicast_mld_snooping_interface.htm",
                                                        "parameters":{
                                                            "vlan":{
                                                                "defaultValue":1
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Multicast Router",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show Current Multicast Router",
                                                "list":[
                                                    {
                                                        "name":"Add Static Multicast Router",
                                                        "pageUrl":"multicast_mld_snooping_multicast_router_add_static_multicast_router_show_static_multicast_router.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show Static Multicast Router",
                                                        "pageUrl":"multicast_mld_snooping_multicast_router_add_static_multicast_router_show_static_multicast_router.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show Current Multicast Router",
                                                        "pageUrl":"multicast_mld_snooping_multicast_router_show_current_multicast_router.htm",
                                                        "parameters":{
                                                            "vlan_type":{
                                                                "defaultValue":"static"
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"MLD Member",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show Current Member",
                                                "list":[
                                                    {
                                                        "name":"Add Static Member",
                                                        "pageUrl":"multicast_mld_snooping_mld_member_add_static_member_show_static_member.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show Static Member",
                                                        "pageUrl":"multicast_mld_snooping_mld_member_add_static_member_show_static_member.htm",
                                                        "parameters":{
                                                            "unit":{ }
                                                        }
                                                    },
                                                    {
                                                        "name":"Show Current Member",
                                                        "pageUrl":"multicast_mld_snooping_mld_member_show_current_member.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            
                                {
                                    "name":"Filter",
                                    "step":{
                                        "list":[
                                            {
                                                "name":"Configure General",
                                                "action":{
                                                    "list":[
                                                        {
                                                            "pageUrl":"multicast_mld_snooping_filter_configure_general.htm"
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                "name":"Configure Profile",
                                                "action":{
                                                    "defaultValue":"Show",
                                                    "list":[
                                                        {
                                                            "name":"Add",
                                                            "pageUrl":"multicast_mld_snooping_filter_configure_profile_add_show.htm"
                                                        },
                                                        {
                                                            "name":"Show",
                                                            "pageUrl":"multicast_mld_snooping_filter_configure_profile_add_show.htm"
                                                        },
                                                        {
                                                            "name":"Add Multicast Group Range",
                                                            "pageUrl":"multicast_mld_snooping_filter_configure_profile_add_multicast_group_range_show_multicast_group_range.htm"
                                                        },
                                                        {
                                                            "name":"Show Multicast Group Range",
                                                            "pageUrl":"multicast_mld_snooping_filter_configure_profile_add_multicast_group_range_show_multicast_group_range.htm"
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                "name":"Configure Interface",
                                                "action":{
                                                    "list":[
                                                        {
                                                            "pageUrl":"multicast_mld_snooping_filter_configure_interface_port.htm",
                                                            "parameters":{
                                                                "unit":{ }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                },
                            
                            
                                {
                                    "name":"Query Drop",
                                    "step":{
                                        "list":[
                                            {
                                                "action":{
                                                    "list":[
                                                        {
                                                            "pageUrl":"multicast_mld_snooping_query_drop_port.htm",
                                                            "parameters":{
                                                                "unit":{ }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                },
                            
                            {
                                "name":"Group Information",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "useTransferPage":true,
                                                        "pageUrl":"multicast_mld_snooping_group_information.htm",
                                                        "parameters":{
                                                            "vlan":{
                                                                "defaultValue":1
                                                            },
                                                            "STRPARAM":{
                                                                "defaultValue":"0_0_0"
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Statistics",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "list":[
                                                    {
                                                        "pageUrl":"multicast_mld_snooping_statistics_input.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                
                
                
                
                
                    {
                        "name":"MVR",
                        "step":{
                            "list":[
                                
                                    {
                                        "name":"Configure Global",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"multicast_mvr_configure_global.htm"
                                                }
                                            ]
                                        }
                                    },
                                
                                {
                                    "name":"Configure Domain",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"multicast_mvr_configure_domain.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Profile",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"multicast_mvr_configure_profile_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"multicast_mvr_configure_profile_add_show.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Associate Profile",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"multicast_mvr_associate_profile_add_show.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"multicast_mvr_associate_profile_add_show.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"multicast_mvr_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Static Group Member",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"multicast_mvr_configure_static_group_member_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"multicast_mvr_configure_static_group_member_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Member",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"multicast_mvr_show_member_domain_id.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Statistics",
                                    "action":{
                                        "list":[
                                            {
                                                "name":"Show Query Statistics",
                                                "pageUrl":"multicast_mvr_show_statistics_show_query_statistics.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show VLAN Statistics",
                                                "pageUrl":"multicast_mvr_show_statistics_show_vlan_statistics.htm",
                                                "parameters":{
                                                    "vlan":{
                                                        "defaultValue":1
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show Port Statistics",
                                                "pageUrl":"multicast_mvr_show_statistics_show_port_statistics.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show Trunk Statistics",
                                                "pageUrl":"multicast_mvr_show_statistics_show_trunk_statistics.htm",
                                                "parameters":{
                                                    "unit":{
                                                        "defaultValue":100
                                                    },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                
                
                    {
                        "name":"MVR6",
                        "step":{
                            "list":[
                                
                                    {
                                        "name":"Configure Global",
                                        "action":{
                                            "list":[
                                                {
                                                    "pageUrl":"multicast_mvr6_configure_global.htm"
                                                }
                                            ]
                                        }
                                    },
                                
                                {
                                    "name":"Configure Domain",
                                    "action":{
                                        "list":[
                                            {
                                                "useTransferPage":true,
                                                "pageUrl":"multicast_mvr6_configure_domain.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Profile",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"multicast_mvr6_configure_profile_add_show.htm"
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"multicast_mvr6_configure_profile_add_show.htm"
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Associate Profile",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"multicast_mvr6_associate_profile_add_show.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"multicast_mvr6_associate_profile_add_show.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Interface",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"multicast_mvr6_configure_interface_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Configure Static Group Member",
                                    "action":{
                                        "defaultValue":"Show",
                                        "list":[
                                            {
                                                "name":"Add",
                                                "pageUrl":"multicast_mvr6_configure_static_group_member_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show",
                                                "pageUrl":"multicast_mvr6_configure_static_group_member_add_show_port.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Member",
                                    "action":{
                                        "list":[
                                            {
                                                "pageUrl":"multicast_mvr6_show_member.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    "name":"Show Statistics",
                                    "action":{
                                        "list":[
                                            {
                                                "name":"Show Query Statistics",
                                                "pageUrl":"multicast_mvr6_show_statistics_show_query_statistics.htm",
                                                "parameters":{
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show VLAN Statistics",
                                                "pageUrl":"multicast_mvr6_show_statistics_show_vlan_statistics.htm",
                                                "parameters":{
                                                    "vlan":{
                                                        "defaultValue":1
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show Port Statistics",
                                                "pageUrl":"multicast_mvr6_show_statistics_show_port_statistics.htm",
                                                "parameters":{
                                                    "unit":{ },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            },
                                            {
                                                "name":"Show Trunk Statistics",
                                                "pageUrl":"multicast_mvr6_show_statistics_show_trunk_statistics.htm",
                                                "parameters":{
                                                    "unit":{
                                                        "defaultValue":100
                                                    },
                                                    "port":{
                                                        "defaultValue":0
                                                    },
                                                    "domainId":{
                                                        "defaultValue":1
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    }
                
            ]
        },
        {
            "name":"Routing Protocol",
            "list":[
                
                    {
                        "name":"RIP",
                        "list":[
                            {
                                "name":"General",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Configure",
                                                "list":[
                                                    {
                                                        "name":"Configure",
                                                        "pageUrl":"routing_protocol_rip_general_configure.htm"
                                                    },
                                                    {
                                                        "name":"Clear Route",
                                                        "pageUrl":"routing_protocol_rip_general_clear_route.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Network",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"routing_protocol_rip_network_add_show_ip_address.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"routing_protocol_rip_network_add_show_ip_address.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Passive Interface",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"routing_protocol_rip_passive_interface_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"routing_protocol_rip_passive_interface_add_show.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Neighbor Address",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"routing_protocol_rip_neighbor_address_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"routing_protocol_rip_neighbor_address_add_show.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Redistribute",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"routing_protocol_rip_redistribute_add_show.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"routing_protocol_rip_redistribute_add_show.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Distance",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"routing_protocol_rip_distance_show_add.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"routing_protocol_rip_distance_show_add.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Interface",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show",
                                                "list":[
                                                    {
                                                        "name":"Add",
                                                        "pageUrl":"routing_protocol_rip_interface_add_show_modify.htm"
                                                    },
                                                    {
                                                        "name":"Show",
                                                        "pageUrl":"routing_protocol_rip_interface_add_show_modify.htm"
                                                    },
                                                    {
                                                        "name":"Modify",
                                                        "pageUrl":"routing_protocol_rip_interface_add_show_modify.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                "name":"Statistics",
                                "step":{
                                    "list":[
                                        {
                                            "action":{
                                                "defaultValue":"Show Interface Information",
                                                "list":[
                                                    {
                                                        "name":"Show Interface Information",
                                                        "pageUrl":"routing_protocol_rip_statistics_show_interface_information_show_peer_information.htm"
                                                    },
                                                    {
                                                        "name":"Show Peer Information",
                                                        "pageUrl":"routing_protocol_rip_statistics_show_interface_information_show_peer_information.htm"
                                                    },
                                                    {
                                                        "name":"Reset Statistics",
                                                        "pageUrl":"routing_protocol_rip_statistics_reset_statistics.htm"
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                
                
                
                
            ]
        },
        {
            "name":"Sync",
            "list":[
                
            ]
        }
    ]

});